#include "tbb/task_scheduler_init.h"
#include "tbb/parallel_scan.h"
#include "tbb/blocked_range.h"
#include "tbb/tick_count.h"
#include <cstdlib>
#include <iostream>

using namespace std;
using namespace tbb;

#define N 10

template <class T>
class SumyCzesciowe {
	const T *x;
	T *y;
public:
	T suma;
	template<class Tag>
	void operator()(const blocked_range<int>& r, Tag) {
		T temp = suma;
		for (int i = r.begin(); i < r.end(); ++i) {
			temp = temp + x[i];
			if (Tag::is_final_scan())
				y[i] = temp;
		}
		suma = temp;
	}
	SumyCzesciowe(const T *tabx, T *taby) : x(tabx), y(taby) {}
	SumyCzesciowe(SumyCzesciowe& s, split) : x(s.x), y(s.y), suma(0) {}
	void reverse_join(SumyCzesciowe& s) { suma += s.suma; }
	void assign(SumyCzesciowe& s) {suma = s.suma; }
};

int main(int argc, char* argv[])
{
	double *x = new double[N], *y = new double[N];
	task_scheduler_init init;
	
	x[0] = 0.1;
	for (int i = 1; i < N; ++i) x[i] = x[i-1] + 0.1;
			
	SumyCzesciowe<double> sumy(x, y);
	parallel_scan(blocked_range<int>(0, N), sumy, auto_partitioner());

	for (int i = 0; i < N; ++i) cout << "  " << y[i];
	delete[] x, y;
	cin.get();
	return 0;
}
